import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.io.*;
import java.awt.event.*;

public class CAD_ButtonPanel extends JPanel implements ActionListener, ItemListener
{
	private int width;
	private int height;
	
	private JFileChooser jfc;
	private static File f1;
	private static File f2;
	
	private JMenuBar jmb;
	private JMenu jmFile;
	private JMenuItem jmiNew;
	private JMenuItem jmiOpen;
	private JMenuItem jmiSave;
	private JMenuItem jmiSaveAs;
	private JMenuItem jmiSaveGCode;
	private JMenuItem jmiPrint;
	private JMenu jmEdit;
	private JMenuItem jmiUnDo;
	private JMenuItem jmiReDo;
	private JMenuItem jmiCopy;
	private JMenuItem jmiMove;
	private JMenuItem jmiDelete;
	private JMenu jmView;
	private JMenuItem jmiZoom;
	private JMenu jmSchematic;
	private JMenuItem jmiCenter;
	private JMenuItem jmiBrowse;
	private JMenu jmHelp;
	private JMenuItem jmiVersion;
	
	private JPanel panelTool;
	private Button btnExit;
	private JButton btnPointer;
	private JButton btnMove;
	private JButton btnLine;
	private JButton btnEraser;
	private JButton btnConstructLine;
	private JButton btnLineContinue;
	private JButton btnRect;
	private JButton btnOval;
	private JButton btnArc;
	private Button btnDot;
	private JButton btnCopy;
	private JButton btnZoom;
	private JButton btnAText;
	private JButton btnText;
	private Button btnGCode;
	private ImageIcon imgPointer;
	private ImageIcon imgMove;
	private ImageIcon imgLine;
	private ImageIcon imgEraser;
	private ImageIcon imgConstructLine;
	private ImageIcon imgLineContinue;
	private ImageIcon imgRect;
	private ImageIcon imgOval;
	private ImageIcon imgArc;
	private ImageIcon imgCopy;
	private ImageIcon imgZoom;
	private ImageIcon imgAText;
	
	private Choice chFont;
	private Choice chLine;
	private Choice chColor;
	private Choice chBGColor;
	private Choice chGrid;
	
	private CAD_JPrint cjp;
	
	public CAD_ButtonPanel(int w, int h) throws Exception
	{
		width = w;
		height = h;
		
		jfc = new JFileChooser();
		setF1(null);
		f2 = null;
		
		try{
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Current.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Electric.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_ElectricC.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_ElectricN.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_ElectricR.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Electric2OV.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Electric2YXB.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Browse.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Result.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo1.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo2.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo3.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo4.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo5.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo6.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo7.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo8.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo9.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo10.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo11.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_UnDo12.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo1.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo2.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo3.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo4.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo5.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo6.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo7.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo8.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo9.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo10.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo11.xml");
			CAD_Transform.CAD_Transform("CAD_BlankFile2.xml", "CAD_ReDo12.xml");
		}catch(Exception e){}
		cjp = new CAD_JPrint((width - 50), height);
		
		jmb = new JMenuBar();
		jmb.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
		
		jmFile = new JMenu("FILE");
		jmFile.setMnemonic('F');
		jmb.add(jmFile);
		
		jmiNew = new JMenuItem("NEW");
		jmiNew.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_Archive.push();
				try{
					CAD_Transform.CAD_Transform("CAD_BlankFile.xml", "CAD_Current.xml");
				CAD_ButtonPanel.setF1(new File("CAD_Current.xml"));
				cjp = new CAD_JPrint(CAD_ButtonPanel.getF1());
				}catch(Exception e){}
				repaint();
				return;
			}
		});
		jmFile.add(jmiNew);
		
		jmiOpen = new JMenuItem("OPEN");
		jmiOpen.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_Archive.push();
				int intRet = jfc.showOpenDialog(CAD_ButtonPanel.this);
				if(intRet == JFileChooser.APPROVE_OPTION)
				{
					f2 = jfc.getSelectedFile();
					try{
						final JTextArea myText = new JTextArea();
						myText.setLineWrap(true);
						String strLine;
						File myFile=jfc.getSelectedFile();
						BufferedReader myReader=new BufferedReader(new FileReader(f2));
						myText.setText(myReader.readLine());
						while((strLine=myReader.readLine()) !=null)
						{
							myText.append("\n" + strLine);
						}
						myReader.close();
						PrintWriter myWriter=new PrintWriter(new BufferedWriter(new FileWriter(new File("CAD_Current.xml"))));
						myWriter.write(myText.getText());
						myWriter.close();
						CAD_ButtonPanel.setF1(f2);
						cjp = new CAD_JPrint(new File("CAD_Current.xml"));
					}catch(Exception e){}
					repaint();
				}
				return;
			}
		});
		jmFile.add(jmiOpen);
		
		jmiSave = new JMenuItem("SAVE");
		jmiSave.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				if((CAD_ButtonPanel.getF1() == null)
					|| (CAD_ButtonPanel.getF1().getName().equals("CAD_Current.xml")))
				{
					int intRet = jfc.showOpenDialog(CAD_ButtonPanel.this);
					if(intRet == JFileChooser.APPROVE_OPTION)
					{
						try{
							final JTextArea myText = new JTextArea();
							myText.setLineWrap(true);
							String strLine;
							File myFile=jfc.getSelectedFile();
							BufferedReader myReader=new BufferedReader(new FileReader(new File("CAD_Current.xml")));
							myText.setText(myReader.readLine());
							while((strLine=myReader.readLine()) !=null)
							{
								myText.append("\n" + strLine);
							}
							myReader.close();
							PrintWriter myWriter=new PrintWriter(new BufferedWriter(new FileWriter(jfc.getSelectedFile().getAbsolutePath())));
							myWriter.write(myText.getText());
							myWriter.close();
							CAD_ButtonPanel.setF1(jfc.getSelectedFile());
						}catch(Exception e){}
						repaint();
					}
				}
				else
				{
					CAD_ButtonPanel.setF1(jfc.getSelectedFile());
						try{
							final JTextArea myText = new JTextArea();
							myText.setLineWrap(true);
							String strLine;
							File myFile=jfc.getSelectedFile();
							BufferedReader myReader=new BufferedReader(new FileReader(new File("CAD_Current.xml")));
							myText.setText(myReader.readLine());
							while((strLine=myReader.readLine()) !=null)
							{
								myText.append("\n" + strLine);
							}
							myReader.close();
							PrintWriter myWriter=new PrintWriter(new BufferedWriter(new FileWriter(CAD_ButtonPanel.getF1().getAbsolutePath())));
							myWriter.write(myText.getText());
							myWriter.close();
						}catch(Exception e){}
					repaint();
				}
				return;
			}
		});
		jmFile.add(jmiSave);
		
		jmiSaveAs = new JMenuItem("SAVE AS");
		jmiSaveAs.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				int intRet = jfc.showOpenDialog(CAD_ButtonPanel.this);
				if(intRet == JFileChooser.APPROVE_OPTION)
				{
					try{
						final JTextArea myText = new JTextArea();
						myText.setLineWrap(true);
						String strLine;
						File myFile=jfc.getSelectedFile();
						BufferedReader myReader=new BufferedReader(new FileReader(new File("CAD_Current.xml")));
						myText.setText(myReader.readLine());
						while((strLine=myReader.readLine()) !=null)
						{
							myText.append("\n" + strLine);
						}
						myReader.close();
						PrintWriter myWriter=new PrintWriter(new BufferedWriter(new FileWriter(jfc.getSelectedFile().getAbsolutePath())));
						myWriter.write(myText.getText());
						myWriter.close();
						CAD_ButtonPanel.setF1(jfc.getSelectedFile());
					}catch(Exception e){}
					repaint();
				}
				return;
			}
		});
		jmFile.add(jmiSaveAs);
		
		jmiSaveGCode = new JMenuItem("SAVE GCODE");
		jmiSaveGCode.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_GCode.write();
				return;
			}
		});
		jmFile.add(jmiSaveGCode);
		
		jmiPrint = new JMenuItem("PRINT");
		jmiPrint.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_Print2DPrinterJob sp = new CAD_Print2DPrinterJob();
				return;
			}
		});
		jmFile.add(jmiPrint);
		
		jmEdit = new JMenu("EDIT");
		jmEdit.setMnemonic('E');
		jmb.add(jmEdit);
		
		jmiUnDo = new JMenuItem("UNDO");
		jmiUnDo.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_Archive.UnDo();
				return;
			}
		});
		jmEdit.add(jmiUnDo);
		
		jmiReDo = new JMenuItem("REDO");
		jmiReDo.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_Archive.ReDo();
				return;
			}
		});
		jmEdit.add(jmiReDo);
		
		jmiCopy = new JMenuItem("COPY");
		jmiCopy.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_JPrint.setSMode("copy");
				return;
			}
		});
		jmEdit.add(jmiCopy);
		
		jmiMove = new JMenuItem("MOVE");
		jmiMove.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_JPrint.setSMode("move");
				return;
			}
		});
		jmEdit.add(jmiMove);
		
		jmiDelete = new JMenuItem("DELETE");
		jmiDelete.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_JPrint.setSMode("eraser");
				return;
			}
		});
		jmEdit.add(jmiDelete);
		
		jmView = new JMenu("VIEW");
		jmView.setMnemonic('V');
		jmb.add(jmView);
		
		jmiZoom = new JMenuItem("ZOOM");
		jmiZoom.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_JPrint.setSMode("zoom");
				return;
			}
		});
		jmView.add(jmiZoom);
		
		jmSchematic = new JMenu("SCHEMATIC");
		jmSchematic.setMnemonic('S');
		jmb.add(jmSchematic);
		
		jmiCenter = new JMenuItem("CENTER");
		jmiCenter.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_JPrint.setSMode("pointer");
				System.out.println("Please Click the OFFSET of this Schematic Center.");
				CAD_JPrint.setSMode2("click_offset_center_off");
				return;
			}
		});
		jmSchematic.add(jmiCenter);
		
		jmiBrowse = new JMenuItem("BROWSE");
		jmiBrowse.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				CAD_JPrint.setSMode("pointer");
				int intRet = jfc.showOpenDialog(CAD_ButtonPanel.this);
				if(intRet == JFileChooser.APPROVE_OPTION)
				{
					f2 = jfc.getSelectedFile();
					try{
						final JTextArea myText = new JTextArea();
						myText.setLineWrap(true);
						String strLine;
						File myFile=jfc.getSelectedFile();
						BufferedReader myReader=new BufferedReader(new FileReader(f2));
						myText.setText(myReader.readLine());
						while((strLine=myReader.readLine()) !=null)
						{
							myText.append("\n" + strLine);
						}
						myReader.close();
						PrintWriter myWriter=new PrintWriter(new BufferedWriter(new FileWriter(new File("CAD_Browse.xml"))));
						myWriter.write(myText.getText());
						myWriter.close();
					}catch(Exception e){}
					System.out.println("Please Click the OFFSET of the Browse Schematic Center.");
					CAD_JPrint.setSMode2("click_browse_center_off");
				}
				return;
			}
		});
		jmSchematic.add(jmiBrowse);
		
		jmHelp = new JMenu("HELP");
		jmHelp.setMnemonic('H');
		jmb.add(jmHelp);
		
		jmiVersion = new JMenuItem("VERSION");
		jmiVersion.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				System.out.println("Java Swing XML CAD Version 1.1.1");
				return;
			}
		});
		jmHelp.add(jmiVersion);
		
		panelTool = new JPanel();
		setBackground(Color.gray);
		
		btnExit = new Button("EXIT");
		btnExit.addActionListener(this);
		btnExit.setSize(50,50);
		
		imgPointer = new ImageIcon(getClass().getResource("Button7.jpg"));
		btnPointer = new JButton(imgPointer);
		btnPointer.addActionListener(this);
		btnPointer.setSize(50,50);
		
		imgMove = new ImageIcon(getClass().getResource("Button22.jpg"));
		btnMove = new JButton(imgMove);
		btnMove.addActionListener(this);
		btnMove.setSize(50,50);
		
		imgLine = new ImageIcon(getClass().getResource("Button1.jpg"));
		btnLine = new JButton(imgLine);
		btnLine.addActionListener(this);
		btnLine.setSize(50,50);
		
		imgEraser = new ImageIcon(getClass().getResource("Button3.jpg"));
		btnEraser = new JButton(imgEraser);
		btnEraser.addActionListener(this);
		btnEraser.setSize(50,50);
		
		imgLineContinue = new ImageIcon(getClass().getResource("Button4.jpg"));
		btnLineContinue = new JButton(imgLineContinue);
		btnLineContinue.addActionListener(this);
		btnLineContinue.setSize(50,50);
		
		imgRect = new ImageIcon(getClass().getResource("Button6.jpg"));
		btnRect = new JButton(imgRect);
		btnRect.addActionListener(this);
		btnRect.setSize(50,50);
		
		imgOval = new ImageIcon(getClass().getResource("Button10.jpg"));
		btnOval = new JButton(imgOval);
		btnOval.addActionListener(this);
		btnOval.setSize(50,50);
		
		btnDot = new Button("DOT");
		btnDot.addActionListener(this);
		btnDot.setSize(50,50);
		
		imgCopy = new ImageIcon(getClass().getResource("Button8.jpg"));
		btnCopy = new JButton(imgCopy);
		btnCopy.addActionListener(this);
		btnCopy.setSize(50,50);
		
		imgZoom = new ImageIcon(getClass().getResource("Button9.jpg"));
		btnZoom = new JButton(imgZoom);
		btnZoom.addActionListener(this);
		btnZoom.setSize(50,50);
		
		imgAText = new ImageIcon(getClass().getResource("Button29.jpg"));
		btnAText = new JButton(imgAText);
		btnAText.addActionListener(this);
		btnAText.setSize(50,50);
		
		chFont = new Choice();
		chFont.add("PLAIN");
		chFont.add("BOLD");
		chFont.add("ITALIC");
		chFont.addItemListener(this);
		chFont.setSize(50, 50);
		
		chLine = new Choice();
		chLine.add("REALLINE");
		chLine.add("SUBLINE");
		chLine.add("ARROWLINE");
		chLine.add("ELECTRICLINE");
		chLine.addItemListener(this);
		chLine.setSize(50, 50);
		
		chColor = new Choice();
		chColor.add("BLUE");
		chColor.add("GREEN");
		chColor.add("CYAN");
		chColor.add("MAGENTA");
		chColor.addItemListener(this);
		chColor.setSize(50, 50);
		
		chBGColor = new Choice();
		chBGColor.add("BGBLACK");
		chBGColor.add("BGWHITE");
		chBGColor.addItemListener(this);
		chBGColor.setSize(50, 50);
		
		chGrid = new Choice();
		chGrid.add("GRID-ON");
		chGrid.add("GRID-OFF");
		chGrid.addItemListener(this);
		chGrid.setSize(50, 50);
		
		btnGCode = new Button("GCODE");
		btnGCode.addActionListener(this);
		btnGCode.setSize(50,50);
		
		panelTool.setLayout(new GridLayout(14, 2));
		panelTool.add(btnPointer);
		panelTool.add(btnMove);
		panelTool.add(btnLine);
		panelTool.add(btnEraser);
		panelTool.add(btnLineContinue);
		panelTool.add(btnRect);
		panelTool.add(btnOval);
		panelTool.add(btnDot);
		panelTool.add(btnCopy);
		panelTool.add(btnZoom);
		panelTool.add(btnAText);
		panelTool.add(chFont);
		panelTool.add(chLine);
		panelTool.add(chColor);
		panelTool.add(chBGColor);
		panelTool.add(chGrid);
		panelTool.add(btnGCode);
		panelTool.add(btnExit);
		panelTool.setSize(100, height);
		this.setLayout(new BorderLayout());
		this.add(jmb, BorderLayout.NORTH);
		this.add(panelTool, BorderLayout.WEST);
		this.add(cjp, BorderLayout.CENTER);
	}
	public void actionPerformed(ActionEvent ae)
	{
		if(ae.getSource().equals(btnExit))
		{
			System.exit(0);
		}
		else if(ae.getSource().equals(btnAText))
		{
			cjp.setMode("atext");
			repaint();
		}
		else if(ae.getSource().equals(btnLine))
		{
			cjp.setMode("line");
			repaint();
		}
		else if(ae.getSource().equals(btnLineContinue))
		{
			cjp.setMode("linecontinue");
			repaint();
		}
		else if(ae.getSource().equals(btnRect))
		{
			cjp.setMode("rect");
			repaint();
		}
		else if(ae.getSource().equals(btnOval))
		{
			cjp.setMode("oval");
			repaint();
		}
		else if(ae.getSource().equals(btnDot))
		{
			cjp.setMode("dot");
			repaint();
		}
		else if(ae.getSource().equals(btnPointer))
		{
			cjp.setMode("pointer");
			repaint();
		}
		else if(ae.getSource().equals(btnMove))
		{
			cjp.setMode("move");
			repaint();
		}
		else if(ae.getSource().equals(btnCopy))
		{
			cjp.setMode("copy");
			repaint();
		}
		else if(ae.getSource().equals(btnEraser))
		{
			cjp.setMode("eraser");
			repaint();
		}
		else if(ae.getSource().equals(btnZoom))
		{
			cjp.setMode("zoom");
			repaint();
		}
		else if(ae.getSource().equals(btnGCode))
		{
			cjp.setMode("gcode");
			repaint();
		}
	}
	
	public void itemStateChanged(ItemEvent ie)
	{
		if(ie.getSource().equals(chFont))
		{
			CAD_JPrint.setChFont(chFont.getSelectedItem());
		}
		else if(ie.getSource().equals(chLine))
		{
			CAD_JPrint.setChLine(chLine.getSelectedItem());
		}
		else if(ie.getSource().equals(chColor))
		{
			CAD_JPrint.setChColor(chColor.getSelectedItem());
		}
		else if(ie.getSource().equals(chBGColor))
		{
			CAD_JPrint.setChBGColor(chBGColor.getSelectedItem());
		}
		else if(ie.getSource().equals(chGrid))
		{
			CAD_JPrint.setChGrid(chGrid.getSelectedItem());
		}
	}
	
	private static void setF1(File F1)
	{
		f1 = F1;
		return;
	}
	
	private static File getF1()
	{
		return f1;
	}
}
