<?xml version="1.0" encoding="SHIFT_JIS"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output encoding="Shift_JIS" method="xml" />
<xsl:template match="/cad/shapes/schematic">
   <cad><shapes><xsl:apply-templates /></shapes></cad>
</xsl:template>
<xsl:template match="/cad/shapes/browse">
   <cad><shapes><xsl:apply-templates /></shapes></cad>
</xsl:template>
<xsl:template match="/cad/shapes/browse/part">
   <xsl:apply-templates select="document(.)" />
</xsl:template>
<xsl:template match="cad/shapes/schematic">
   <schematic><xsl:apply-templates /></schematic>
</xsl:template>
<xsl:template match="cad/shapes/schematic/center">
   <center><xsl:apply-templates /></center>
</xsl:template>
<xsl:template match="cad/shapes/schematic/center/offsetX">
   <offsetX><xsl:apply-templates /></offsetX>
</xsl:template>
<xsl:template match="cad/shapes/schematic/center/offsetY">
   <offsetY><xsl:apply-templates /></offsetY>
</xsl:template>
<xsl:template match="cad/shapes/electric">
   <electric><xsl:apply-templates /></electric>
</xsl:template>
<xsl:template match="cad/shapes/electric/linkMember">
   <linkMember>
      <xsl:attribute name="LinkMemberName">
         <xsl:value-of select="@LinkMemberName" />
      </xsl:attribute>
      <xsl:apply-templates />
   </linkMember>
</xsl:template>
<xsl:template match="cad/shapes/electric/linkMember/v">
   <v><xsl:apply-templates /></v>
</xsl:template>
<xsl:template match="cad/shapes/electric/linkMember/linkMemberDot">
   <linkMemberDot><xsl:apply-templates /></linkMemberDot>
</xsl:template>
<xsl:template match="cad/shapes/electric/linkMember/linkMemberDot/linkMemberX">
   <linkMemberX><xsl:apply-templates /></linkMemberX>
</xsl:template>
<xsl:template match="cad/shapes/electric/linkMember/linkMemberDot/linkMemberY">
   <linkMemberY><xsl:apply-templates /></linkMemberY>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape">
   <shape><xsl:apply-templates /></shape>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/text">
   <text>
      <xsl:attribute name="Font">
         <xsl:value-of select="@Font" />
      </xsl:attribute>
      <xsl:attribute name="FontSize">
         <xsl:value-of select="@FontSize" />
      </xsl:attribute>
      <xsl:attribute name="X">
         <xsl:value-of select="@X" />
      </xsl:attribute>
      <xsl:attribute name="Y">
         <xsl:value-of select="@Y" />
      </xsl:attribute>
      <xsl:attribute name="Color">
         <xsl:value-of select="@Color" />
      </xsl:attribute>
      <xsl:apply-templates />
   </text>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/line">
   <line>
      <xsl:attribute name="Color">
         <xsl:value-of select="@Color" />
      </xsl:attribute>
      <xsl:attribute name="Line">
         <xsl:value-of select="@Line" />
      </xsl:attribute>
      <xsl:apply-templates />
   </line>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/line/i">
   <i><xsl:apply-templates /></i>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/line/dot">
   <dot><xsl:apply-templates /></dot>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/line/dot/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/line/dot/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval">
   <oval>
      <xsl:attribute name="Color">
         <xsl:value-of select="@Color" />
      </xsl:attribute>
      <xsl:attribute name="Line">
         <xsl:value-of select="@Line" />
      </xsl:attribute>
      <xsl:apply-templates />
   </oval>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval/width">
   <width><xsl:apply-templates /></width>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval/height">
   <height><xsl:apply-templates /></height>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval/degrees0">
   <degrees0><xsl:apply-templates /></degrees0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/oval/degrees1">
   <degrees1><xsl:apply-templates /></degrees1>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot">
   <dot>
      <xsl:attribute name="Dot">
         <xsl:value-of select="@Dot" />
      </xsl:attribute>
      <xsl:apply-templates />
   </dot>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/out">
   <out><xsl:apply-templates /></out>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/out/v">
   <v><xsl:apply-templates /></v>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/out/i">
   <i><xsl:apply-templates /></i>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active">
   <active><xsl:apply-templates /></active>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV">
   <variableV>
      <xsl:attribute name="VariableVName">
         <xsl:value-of select="@VariableVName" />
      </xsl:attribute>
      <xsl:apply-templates />
   </variableV>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/function">
   <function><xsl:apply-templates /></function>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/a">
   <a><xsl:apply-templates /></a>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/b">
   <b><xsl:apply-templates /></b>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/c">
   <c><xsl:apply-templates /></c>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/x0">
   <x0><xsl:apply-templates /></x0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/y0">
   <y0><xsl:apply-templates /></y0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableV/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI">
   <variableI>
      <xsl:attribute name="VariableIName">
         <xsl:value-of select="@VariableIName" />
      </xsl:attribute>
      <xsl:apply-templates />
   </variableI>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/function">
   <function><xsl:apply-templates /></function>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/a">
   <a><xsl:apply-templates /></a>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/b">
   <b><xsl:apply-templates /></b>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/c">
   <c><xsl:apply-templates /></c>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/x0">
   <x0><xsl:apply-templates /></x0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/y0">
   <y0><xsl:apply-templates /></y0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/active/variableI/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive">
   <passive><xsl:apply-templates /></passive>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV">
   <variableV>
      <xsl:attribute name="VariableVName">
         <xsl:value-of select="@VariableVName" />
      </xsl:attribute>
      <xsl:apply-templates />
   </variableV>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/function">
   <function><xsl:apply-templates /></function>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/a">
   <a><xsl:apply-templates /></a>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/b">
   <b><xsl:apply-templates /></b>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/c">
   <c><xsl:apply-templates /></c>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/x0">
   <x0><xsl:apply-templates /></x0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/y0">
   <y0><xsl:apply-templates /></y0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableV/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI">
   <variableI>
      <xsl:attribute name="VariableIName">
         <xsl:value-of select="@VariableIName" />
      </xsl:attribute>
      <xsl:apply-templates />
   </variableI>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/function">
   <function><xsl:apply-templates /></function>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/a">
   <a><xsl:apply-templates /></a>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/b">
   <b><xsl:apply-templates /></b>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/c">
   <c><xsl:apply-templates /></c>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/x0">
   <x0><xsl:apply-templates /></x0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/y0">
   <y0><xsl:apply-templates /></y0>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/x">
   <x><xsl:apply-templates /></x>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/passive/variableI/y">
   <y><xsl:apply-templates /></y>
</xsl:template>
<xsl:template match="cad/shapes/schematic/shape/dot/in">
   <in><xsl:apply-templates /></in>
</xsl:template>
</xsl:stylesheet>